/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.oracle.test;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.UrlAwareDataSource;
import org.codefilarete.stalactite.sql.oracle.test.OracleDataSource;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class OracleEmbeddableDataSource
extends UrlAwareDataSource
implements Closeable {
    public static final int ORACLE_DEFAULT_PORT = 1521;
    public static final int DEFAULT_PORT = 1522;
    private static final Map<Integer, OracleContainer> USED_PORTS = new HashMap<Integer, OracleContainer>();
    private OracleContainer container;
    private final int port;

    public OracleEmbeddableDataSource() {
        this(1522);
    }

    public OracleEmbeddableDataSource(int port) {
        this(port, "test" + Integer.toHexString(new Random().nextInt()));
    }

    private OracleEmbeddableDataSource(int port, String databaseName) {
        super("jdbc:oracle:thin:@localhost:" + port + ":" + databaseName);
        this.port = port;
        this.start(databaseName);
        this.setDelegate((DataSource)((Object)new OracleDataSource("localhost", port, "localSID", this.container.getUsername(), this.container.getPassword())));
    }

    private void start(String databaseName) {
        this.container = USED_PORTS.get(this.port);
        if (this.container == null) {
            OracleContainer oracleContainer = new OracleContainer(DockerImageName.parse((String)"gvenzl/oracle-free:23-slim-faststart").asCompatibleSubstituteFor("gvenzl/oracle-xe"));
            ((OracleContainer)oracleContainer.withDatabaseName("localSID").withUsername(databaseName).withPassword(databaseName).withPrivilegedMode(true)).setPortBindings(Arrays.asList(this.port + ":" + 1521));
            oracleContainer.start();
            USED_PORTS.put(this.port, oracleContainer);
            this.container = oracleContainer;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                OracleContainer existingContainer = USED_PORTS.get(this.port);
                if (existingContainer != null && existingContainer.isRunning()) {
                    existingContainer.stop();
                }
            }));
        }
    }

    @Override
    public void close() {
        USED_PORTS.get(this.port).stop();
        USED_PORTS.remove(this.port);
    }
}

